﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="n0" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Paski wypłat</title>
		<script runat="server">

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //static bool procentInfo = false;
        bool procentInfo = false;
        [Priority(1)]
        [Caption("Kolumna %")]
        public bool ProcentInfo {
            get { return procentInfo; }
            set {
                procentInfo = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool infoNorma = false;
        [Priority(2)]
        [Caption("Informacja o normie")]
        public bool InfoNorma {
            get { return infoNorma; }
            set {
                infoNorma = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool pelneStanowisko = false;
        [Priority(1)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }        
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }

    private string Korygowany(WypElement element) {
        string korektaTxt = " (korekta)";
        string depozytTxt = " (depozyt)";
        string nazwa = element.Nazwa;
        if (element.Definicja.Korygowany && nazwa.EndsWith(korektaTxt))
            nazwa = nazwa.Replace(korektaTxt, "");
        else if (element is WypElementZajęcieKomornicze && nazwa.EndsWith(depozytTxt))
            nazwa = nazwa.Replace(depozytTxt, "");
        return nazwa;
    }
    
    private void gridElements_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        WypElement element = (WypElement)args.Row;

        switch (element.RodzajZrodla) {
            case RodzajŹródłaWypłaty.NadgodzinyI:
            case RodzajŹródłaWypłaty.NadgodzinyII:
            case RodzajŹródłaWypłaty.NadgodzinyŚw:
            case RodzajŹródłaWypłaty.Nocne:
            case RodzajŹródłaWypłaty.Etat:
                args.VisibleRow = false;
                return;
        }

        if (element.Wartosc == 0)
            args.VisibleRow = false;
        else {
            colNazwa.AddLine(Korygowany(element));
            WypSkladnikGłówny skg = element.SkładnikGłówny;
            colProcent.AddLine(skg == null ? Percent.Zero : skg.Procent);
            colCzas.AddLine(element.Czas);
            colDni.AddLine(element.Dni);
            AddWartosc(element.Wartosc);
        }
    }

    void AddWartosc(decimal v) {
        if (v >= 0)
            colDodatek.EditValue = v;
        else
            colPotracenie.EditValue = -v;
    }

    private void dc_ContextLoad(object sender, System.EventArgs e) {
        colProcent.Visible = srpars.ProcentInfo;
        if (dc.Context.Contains(typeof(Wyplata))) {
            Wyplata wypłata = (Wyplata)dc[typeof(Wyplata)];
            DataRepeater1.DataSource = new object[] { wypłata };
        }
        else {
            ListaPlac lista = (ListaPlac)dc[typeof(ListaPlac)];
            DataRepeater1.DataSource = lista.Wyplaty;
        }
    }

    protected void DataRepeater1_BeforeRow(object sender, EventArgs e) {
        if (!(DataRepeater1.CurrentRow is WyplataEtat))
            throw new Exception("Wydruk działa tylko dla wypłat etatowych");

        WyplataEtat wypłata = DataRepeater1.CurrentRow as WyplataEtat;
        if (wypłata == null)
            throw new RowException(wypłata, "Wydruk może drukować wyłącznie wypłaty etatowe.");

        if (srpars.InfoNorma) {
            sectionNorma.Visible = true;
            KalkulatorPracownika kalk = new KalkulatorPracownika(wypłata.Pracownik);
            CzasDni norma = kalk.Norma(wypłata.ListaPlac.Okres);
            labelNorma.EditValue = norma.Czas + " / " + norma.Dni;
        }
        else
            sectionNorma.Visible = false;

        SkladkiPPK.Visible = JestPPK(wypłata, wypłata.ListaPlac.DataWyplaty);
        string format = wypłata.WartoscCy.Symbol == Currency.SystemSymbol ? "{0:n}" : "{0}";
        dlGotówka.Format = format;
        dlRor.Format = format;
        
        labelStanowisko.EditValue = GetStanowisko(wypłata.PracHistoria);
    }

     private bool JestPPK(ISessionable session, Date data) {
        YearMonth podlegaOd = PlaceModule.GetInstance(session).Config.PracowniczePlanyKapitałowe.Ogólne.PodlegaOd;
        return podlegaOd != YearMonth.Empty ? new FromTo(podlegaOd.FirstDay, Date.MaxValue).Contains(data) : false;
     }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srpars.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }    
</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<font face="Tahoma">
			<form id="form" method="post" runat="server">
				<ea:datacontext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:datacontext>
				<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%" RowTypeName="Soneta.Place.WyplataEtat,Soneta.KadryPlace" OnBeforeRow="DataRepeater1_BeforeRow">
					<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
					<TABLE id="Table1" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0"
						width="100%" border="0">
						<TR>
							<TD>
								<P>
									<TABLE id="Table2" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0"
										width="100%" border="0">
										<TR>
											<TD width="40%">Wypłata za okres:
											</TD>
											<TD>
												<ea:DataLabel id="DataLabel1" runat="server" DataMember="ListaPlac.Okres"></ea:DataLabel></TD>
										</TR>
										<TR>
											<TD>Data wypłaty:</TD>
											<TD>
												<ea:DataLabel id="DataLabel2" runat="server" DataMember="Data"></ea:DataLabel></TD>
										</TR>
										<TR>
											<TD>Pracownik:</TD>
											<TD>
												<ea:DataLabel id="DataLabel3" runat="server" DataMember="Pracownik"></ea:DataLabel></TD>
										</TR>
										<TR>
											<TD>Stanowisko:</TD>
											<TD>
												<ea:DataLabel id="labelStanowisko" runat="server"></ea:DataLabel></TD>
										</TR>
										<TR>
											<TD>PESEL:</TD>
											<TD>
												<ea:DataLabel id="DataLabel5" runat="server" DataMember="PracHistoria.PESEL"></ea:DataLabel></TD>
										</TR>
										<TR>
											<TD>Kod tytułu ubezpieczenia:
											</TD>
											<TD>
												<ea:DataLabel id="DataLabel6" runat="server" 
                        DataMember="Workers.ZUSInfo.TytułUbezpieczenia"></ea:DataLabel></TD>
										</TR>
										<TR>
											<TD>
                                                Oddział NFZ:
											</TD>
											<TD>
												<ea:DataLabel id="DataLabel7" runat="server" DataMember="PracHistoria.OddzialNFZ.Oddział.Nazwa"></ea:DataLabel></TD>
										</TR>
									</TABLE>
								</P>
								<TABLE id="Table3" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0"
									width="100%" border="0">
                                    <ea:Section id="sectionNorma" runat="server">
									<TR>
										<TD colSpan="4"><STRONG>
                                            <EM>Norma </EM></STRONG>&nbsp;
											<ea:DataLabel id="labelNorma" runat="server"></ea:DataLabel> 
										</TD>
									</TR>
                                    </ea:Section>
									<TR>
										<TD colSpan="4"><STRONG>
                                            <EM>Przepracował </EM></STRONG>&nbsp;
											<ea:DataLabel id="DataLabel8" runat="server" DataMember="Workers.CzasInfo.PracaDni"></ea:DataLabel>&nbsp;dni 
											(
											<ea:DataLabel id="DataLabel9" runat="server" DataMember="Workers.CzasInfo.PracaCzas"></ea:DataLabel>&nbsp;godzin), 
											w tym:
										</TD>
									</TR>
									<TR>
										<TD width="2%"></TD>
										<TD width="38%">Czas przepracowany ponad/poniżej normy:</TD>
										<TD align="right" width="20%">
											<ea:DataLabel id="DataLabel10" runat="server" DataMember="Workers.CzasInfo.Odchyłka"></ea:DataLabel></TD>
										<TD width="40%"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Czas pracy w nocy:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel11" runat="server" DataMember="Workers.CzasInfo.Nocne"></ea:DataLabel></TD>
										<TD></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Nadgodziny +50%:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel12" runat="server" DataMember="Workers.CzasInfo.Nadgodziny50"></ea:DataLabel></TD>
										<TD></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Nadgodziny +100%:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel13" runat="server" DataMember="Workers.CzasInfo.Nadgodziny100"></ea:DataLabel></TD>
										<TD></TD>
									</TR>
								</TABLE>
								<TABLE id="Table4" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0"
									width="100%" border="0">
									<TR>
										<TD colSpan="4"><STRONG>
                                            <EM>Nieobecności</EM></STRONG></TD>
									</TR>
									<TR>
										<TD width="2%"></TD>
										<TD width="38%">Zwolnienie chorobowe (dni):</TD>
										<TD align="right" width="20%">
											<ea:DataLabel id="DataLabel14" runat="server" DataMember="Workers.CzasInfo.Chorobowe.Dni"></ea:DataLabel></TD>
										<TD width="40%"></TD>
									</TR>
									<TR>
										<TD style="HEIGHT: 14px"></TD>
										<TD style="HEIGHT: 14px">Urlop wypoczynkowy (dni/godzin):
										</TD>
										<TD style="HEIGHT: 14px" align="right">
											<ea:DataLabel id="DataLabel16" runat="server" DataMember="Workers.CzasInfo.Urlop.Dni"></ea:DataLabel>/
											<ea:DataLabel id="DataLabel27" runat="server" DataMember="Workers.CzasInfo.Urlop.Czas"></ea:DataLabel></TD>
										<TD style="HEIGHT: 14px"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Pozostałe nieobecności (dni):</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel15" runat="server" DataMember="Workers.CzasInfo.Pozostałe.Dni"></ea:DataLabel></TD>
										<TD></TD>
									</TR>
								</TABLE>
								<TABLE id="Table5" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0"
									width="100%" border="0">
									<TR>
										<TD colSpan="3"><STRONG>
                                            <EM>Rozliczenie czasu pracy</EM></STRONG></TD>
										<TD></TD>
									</TR>
									<TR>
										<TD width="2%"></TD>
										<TD width="38%">Wynagrodzenie zasadnicze:</TD>
										<TD align="right" width="20%">
											<ea:DataLabel id="DataLabel39" runat="server" DataMember="Workers.WyplataEtat.Zasadnicze" Format="{0:n}"></ea:DataLabel></TD>
										<TD width="40%"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Dopłata do nadgodzin +50%:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel19" runat="server" DataMember="Workers.WyplataEtat.Nadgodziny50" Format="{0:n}"
												></ea:DataLabel></TD>
										<TD></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Dopłata do nadgodzin +100%:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel18" runat="server" DataMember="Workers.WyplataEtat.Nadgodziny100" Format="{0:n}"></ea:DataLabel></TD>
										<TD></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Dopłata za pracę w nocy:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel17" runat="server" DataMember="Workers.WyplataEtat.Nocne" Format="{0:n}"></ea:DataLabel></TD>
										<TD></TD>
									</TR>
								</TABLE>
								<P><STRONG><EM>Dodatki/Potrącenia</EM></STRONG>
									<ea:Grid id="gridElements" runat="server" DataMember="ElementyWgKolejności" onbeforerow="gridElements_BeforeRow"
										WithSections="False">
										<Columns>
											<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="L.p."></ea:GridColumn>
											<ea:GridColumn Caption="Nazwa" ID="colNazwa" NoWrap="True"></ea:GridColumn>
											<ea:GridColumn Width="10" Align="Right" Caption="Procent" HideZero="True" ID="colProcent" VAlign="Top"></ea:GridColumn>
											<ea:GridColumn Width="10" Align="Right" Caption="godz:min" HideZero="True" ID="colCzas"></ea:GridColumn>
											<ea:GridColumn Width="10" Align="Right" Caption="Dni" HideZero="True" ID="colDni"></ea:GridColumn>
											<ea:GridColumn Width="15" Align="Right" Caption="Dodatek" HideZero="True" Format="{0:n}" ID="colDodatek"></ea:GridColumn>
											<ea:GridColumn Width="15" Align="Right" Caption="Potrącenie" HideZero="True" Format="{0:n}" ID="colPotracenie"></ea:GridColumn>
										</Columns>
									</ea:Grid></P>
                                <ea:pagebreak id="PageBreak2" runat="server" Required="false"></ea:pagebreak>
								<TABLE id="Table7" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0"
									width="100%" border="0">
									<TR>
										<TD colSpan="4"><STRONG>
                                            <EM>Suma elementów</EM></STRONG></TD>
									</TR>
									<TR>
										<TD width="2%"></TD>
										<TD width="38%">Opodatkowanych:</TD>
										<TD align="right" width="20%">
											<ea:DataLabel id="DataLabel31" runat="server" DataMember="Workers.PITInfo.Brutto" Format="{0:n}"></ea:DataLabel></TD>
										<TD width="40%"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Nieopodatkowanych:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel23" runat="server" DataMember="Workers.PITInfo.Netto" Format="{0:n}"></ea:DataLabel></TD>
										<TD></TD>
									</TR>
								</TABLE>
                                <ea:pagebreak id="PageBreak3" runat="server" Required="false"></ea:pagebreak>
								<TABLE id="Table8" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0"
									width="100%" border="0">
									<TR>
										<TD colSpan="4"><STRONG>
                                            <EM>Podstawa naliczania składki na ubezpieczenie</EM></STRONG></TD>
									</TR>
									<TR>
										<TD width="2%"></TD>
										<TD width="38%">
                                            Emerytalno-rentowe:</TD>
										<TD align="right" width="20%">
											<ea:DataLabel id="DataLabel24" runat="server" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Podstawa"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD align="right" width="40%"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Chorobowo-wypadkowe:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel25" runat="server" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Podstawa"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD align="right"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Zdrowotne:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel26" runat="server" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Podstawa"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD align="right"></TD>
									</TR>
								</TABLE>
                                <ea:pagebreak id="PageBreak4" runat="server" Required="false"></ea:pagebreak>
								<TABLE id="Table9" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0"
									width="100%" border="0">
									<TR>
										<TD colSpan="2"><STRONG>
                                            <EM>Składki na ubezpieczenie</EM></STRONG></TD>
										<TD align="right" width="20%"><EM>Ubezpieczonego</EM></TD>
										<TD align="right" width="20%"><EM>Płatnika</EM></TD>
										<TD width="20%"></TD>
									</TR>
									<TR>
										<TD width="2%"></TD>
										<TD width="38%">Emerytalne:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel30" runat="server" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Prac"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel20" runat="server" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Firma"></ea:DataLabel></TD>
										<TD align="right"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Rentowe:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel21" runat="server" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Prac"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel22" runat="server" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Firma"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD align="right"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>
                                            Chorobowe/Wypadkowe:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel28" runat="server" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Prac"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel29" runat="server" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Firma"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD align="right"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD><STRONG>SUMA:</STRONG></TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel33" runat="server" DataMember="Workers.WyplataSkładki.Razem.KosztyZUS"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel34" runat="server" DataMember="Workers.WyplataSkładki.Razem.FirmaZUS"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD align="right"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Zdrowotne:&nbsp;</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel32" runat="server" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Prac"
												Format="{0:n}"></ea:DataLabel></TD>
										<TD></TD>
										<TD></TD>
									</TR>
								</TABLE>
                                <ea:pagebreak id="PageBreak7" runat="server" Required="false"></ea:pagebreak>
                                <ea:Section id="SkladkiPPK" runat="server">
                                <TABLE id="Table10" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0"
									width="100%" border="0">
									<TR>
										<TD colSpan="2"><STRONG><EM>Składki na PPK</EM></STRONG></TD>
										<TD align="right" width="20%"><EM>Podstawowa</EM></TD>
										<TD align="right" width="20%"><EM>Dodatkowa</EM></TD>
										<TD align="right" width="20%"><EM>Razem</EM></TD>
									</TR>
									<TR>
										<TD width="2%"></TD>
										<TD width="38%">Pracownika:</TD>
										<TD align="right"><ea:DataLabel id="DataLabel4" runat="server" DataMember="Workers.WyplataSkładki.Razem.PPK.PodstPracownika" Format="{0:n}"/></TD>
										<TD align="right"><ea:DataLabel id="DataLabel35" runat="server" DataMember="Workers.WyplataSkładki.Razem.PPK.DodPracownika"/></TD>
										<TD align="right"><ea:DataLabel id="DataLabel42" runat="server" DataMember="Workers.WyplataSkładki.Razem.PPK.Pracownika"/></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Pracodawcy:</TD>
										<TD align="right"><ea:DataLabel id="DataLabel40" runat="server" DataMember="Workers.WyplataSkładki.Razem.PPK.PodstPracodawcy" Format="{0:n}"/></TD>
										<TD align="right"><ea:DataLabel id="DataLabel41" runat="server" DataMember="Workers.WyplataSkładki.Razem.PPK.DodPracodawcy" Format="{0:n}"/></TD>
										<TD align="right"><ea:DataLabel id="DataLabel43" runat="server" DataMember="Workers.WyplataSkładki.Razem.PPK.Pracodawcy" Format="{0:n}"/></TD>
									</TR>
								</TABLE>
                                </ea:Section>
                                <ea:pagebreak id="PageBreak5" runat="server" Required="false"></ea:pagebreak>
								<TABLE id="Table6" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD colSpan="4"><STRONG>
                                            <EM>Zaliczka podatku</EM></STRONG></TD>
									</TR>
									<TR>
										<TD width="2%"></TD>
										<TD width="38%">Wynagrodzenia:</TD>
										<TD align="right" width="20%">
											<ea:DataLabel id="DataLabel38" runat="server" DataMember="Workers.PITInfo.ZalFISNieZas" Format="{0:n}"
												></ea:DataLabel></TD>
										<TD width="40%"></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Zasiłki:</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel37" runat="server" DataMember="Workers.PITInfo.ZalFISZas" Format="{0:n}"></ea:DataLabel></TD>
										<TD></TD>
									</TR>
									<TR>
										<TD></TD>
										<TD>Korekta zaliczki podatku (za ubiegły rok):</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel36" runat="server" DataMember="Workers.WyplataEtat.RozlPit" Format="{0:n}"
												></ea:DataLabel></TD>
										<TD></TD>
									</TR>
								</TABLE>
                                <ea:pagebreak id="PageBreak6" runat="server" Required="false"></ea:pagebreak>
								<TABLE id="Table10" style="FONT-SIZE: 10pt; FONT-FAMILY: Tahoma" cellSpacing="0" cellPadding="0"
									width="100%" border="0">
									<TR>
										<TD colSpan="4"><STRONG>
                                            <EM>Do wypłaty</EM></STRONG></TD>
									</TR>
									<TR>
										<TD width="2%"></TD>
										<TD width="38%">Gotówka:</TD>
										<TD align="right" width="20%">
											<ea:DataLabel id="dlGotówka" runat="server" DataMember="Gotówka" Format="{0:n}" ></ea:DataLabel></TD>
										<TD width="40%">
                                            &nbsp;</TD>
									</TR>
									<TR>
										<TD style="height: 16px"></TD>
										<TD style="height: 16px">ROR:</TD>
										<TD align="right" style="height: 16px">
											<ea:DataLabel id="dlRor" runat="server" DataMember="Inne" Format="{0:n}"></ea:DataLabel></TD>
										<TD style="height: 16px">
                                            &nbsp;</TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
					</TABLE>
					<n0:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></n0:ReportFooter>
				</ea:DataRepeater>
			</form>
		</font>
	</body>
</HTML>

